<?php
include_once CORE_INCLUDE_DIR.'/objectPage.php';

class admin_ome_queue extends objectPage{
    var $object = 'plugins/ome/ome_queue';
    var $workground = 'order';
    var $canRemove = false;
    var $deleteAble = false;
    var $allowImport = false;
    var $allowExport = false;
    var $noRecycle = true;
    var $finder_default_cols = '_cmd,entity_id,entity_type,status,apiname,msg_id,message,send_num,log_create_time';
    
    function index(){
        if ( !$this->system->getConf('app.ome.omenodeid') ) {
            $this->splash('failed','?ctl=system/appmgr&act=setting&p[0]=ome&operation_type=config&version=2.0','请先绑定OME后使用该功能');
        }
        
        parent::index();
    }
    
    function custom_actions() {
        return array(
            'multiretry'=>array(
                'tpl'=>'file:'.dirname(__FILE__).'/view/queue/filter_actions.html',
            ),
        );
    }
    
    function add($order_id,$return=false) {
        if ( !$order_id ) return;

        $matrixMdl = $this->system->loadModel('system/matrix');

        // 订单数据
        $trade = $matrixMdl->format_matrix_trade($order_id);
        $this->system->loadModel('plugins/ome/ome_queue')->add($trade,$order_id,'order','store.trade.add');
        
        if ( $return ) {
            return true;
        }
        $this->splash('success','?ctl=order/order','订单已入队列等待发送');
    }
    
    function multi_add() {

        if ( !$orders = (array)$_POST['order_id'] ) {
            return;
        }
        foreach( $orders as $order_id ) {
            $this->add($order_id, true);
        }
        
        $this->splash('success','?ctl=order/order','订单已入队列等待发送');
    }
    
    function retry($queue_id,$return=false) {
        if ( !($queue_id = (int)$queue_id) ) return;
        $sql = "UPDATE sdb_ome_queue SET status='ready',send_num=0,message='',log_create_time='0',last_send_time='0' WHERE status NOT IN ('ready','locking') AND queue_id='$queue_id'";
        
        $this->db->exec($sql);
        
        if ( $return ) {
            return true;
        }
        $this->splash('success','?ctl=plugins/ome_queue','重置队列等待发送');
    }
    
    function multi_retry() {
        foreach( $_POST['queue_id'] as $queue_id ) {
            $this->retry($queue_id,true);
        }
        
        $this->splash('success','?ctl=plugins/ome_queue','重置队列等待发送');
    }
    
    function matrix_callback() {
        $queue_id = $_GET['queue_id'];
        $queueMdl =& $this->system->loadModel('plugins/ome/ome_queue');
        $queueMdl->update($queue_id,null,$_POST);
        echo 'succ';
    }
    
    function _detail(){
        return array(
            'show_detail'=>array('label'=>__('详细信息'),'tpl'=>'file:'.dirname(__FILE__).'/view/detail.html'),
        );
    }
    
    function show_detail($log_id){
        $queueMdl =& $this->system->loadModel('plugins/ome/ome_queue');
        $res = $queueMdl->get_queue_by_id($log_id);
        
        $res['to_node_id'] = $this->system->getConf('app.ome.omenodeid');
        $res['from_node_id'] = $this->system->loadModel('service/certificate')->getNodeid();
        $res['data'] = strip_tags($res['data']);
        
        $res['queue_id'] = $log_id;
        
        $this->pagedata['res'] = $res;
    }
    
    function _views(){
        return array(
            __('全部')=>'',
            __('进行中')=>array('status'=>array('ready','matrixhold','locking')),
            __('失败')=>array('status'=>array('fail','syncfail','matrixreject')),
        );
    }
}
