<?php
if ( !class_exists('shopObject') ) {
    include CORE_INCLUDE_DIR.'/shopObject.php';
}

class mdl_ome_queue extends shopObject {
    var $idColumn = 'queue_id';
    var $defaultCols = 'entity_id,entity_type,apiname,status,send_num,msg_id,message,log_create_time,last_send_time';
    var $tableName = 'sdb_ome_queue';
    var $defaultOrder = array('orderBy'=>'queue_id','orderType'=>'DESC');
    
    function getColumns(){
        $ret = parent::getColumns();
        $ret['_cmd'] = array('label'=>'操作','width'=>30,'html'=>dirname(__FILE__).'/view/queue/filter_command.html');
        return $ret;
    }

    function searchOptions(){
        return array(
            'entity_id'=>__('单号'),
            'status'=>__('状态'),
            'apiname'=>__('接口名'),
        );
    }
    
    function &_columns(){
        $appmgr = $this->system->loadModel('system/appmgr');
        $ome = &$appmgr->load('ome');

        if(file_exists(dirname($ome->plugin_path).'/dbschema/queue.php')){
            require(dirname($ome->plugin_path).'/dbschema/queue.php');
            $this->__table_define = &$db['queue']['columns'];
        }
        return $this->__table_define;
    }
    
    /**
        1. $entity_type,$entity_id 实体类型和实体id，唯一确定一个实体,eg('order','20090312137181')
        2. $data 实体数据
        3. $apiname,$resp 与矩阵互通用到的api, 矩阵返回的msg id, 矩阵其他消息
    */
    function add($data,$entity_id,$entity_type,$apiname) {
        if ( !$data || !$entity_id || !$entity_type || !$apiname) {
            return;
        }
        
        $log = array (
            'entity_type'=>$entity_type,
            'entity_id'=>$entity_id,
            'apiname'=>$apiname,
            'status'=>'ready',
            'send_num'=>0,
            'log_create_time' => NOW,
            'data' => serialize($data),
        );
        
        return $this->db->insert('sdb_ome_queue',$log);
    }
    
    function update($queue_id,$resp,$from_callback=false) {
        if ( !($queue_id = (int)$queue_id) ) {
            return;
        }
        
        if( !$resp || !($_resp = json_decode($resp,true)) ) {// 矩阵同步失败,网络问题、矩阵服务器问题
            $msg = '网络或服务器异常';
            $status = 'syncfail';
        } else {
            $msg_id = $_resp['msg_id'];
            $msg = serialize($_resp);
            switch( true ) {
                default: $status = 'matrixhold'; break;
                case 'fail' == strtolower($_resp['rsp']): $status = 'fail'; break;
                case 'succ' == strtolower($_resp['rsp']): $status = 'succ'; break;
            }
        }
        
        $sql = "SELECT * FROM sdb_ome_queue WHERE queue_id=$queue_id LIMIT 1";
        $rs = $this->db->exec($sql);
        $row = $this->db->getRows($rs,1);
        if ( !($row = $row[0]) ) {
            return;
        }
        
        $log = array(
            'queue_id'=>$queue_id,
            'status'=>$status,
            'message'=>$msg,
            'msg_id'=>$msg_id,
        );
        if ( !$from_callback ) { //来自矩阵的回调 不更新发送次数
            $log['send_num'] = 1+$row['send_num'];
            $log['last_send_time'] = NOW;
        }
        if ( $sql = $this->db->getUpdateSql($rs, $log) ) {
            $this->db->exec($sql);
        }
    }
    
    function get_queue_by_id($id) {
        $row = $this->db->selectrow('SELECT * FROM sdb_ome_queue WHERE queue_id='.intval($id));
        return $row;
    }
}
