<?php

class ome_mdl_matrix extends shopObject{
    function run_queue() {
        $time_limit = NOW - 30*60;
        $sql = "SELECT queue_id,data,apiname FROM sdb_ome_queue WHERE (status='ready') OR (status='syncfail' AND send_num<3) AND log_create_time>$time_limit ORDER BY log_create_time DESC LIMIT 600";
        if ( !$rows = $this->db->select($sql) ) {
            return;
        }
        
        $queueMdl =& $this->system->loadModel('plugins/ome/ome_queue');
        foreach( $rows as $v ) {
            $data = unserialize($v['data']);
            $resp = $this->push_async($v['queue_id'],$data, $v['apiname']);
            
            $queueMdl->update($v['queue_id'],$resp);
        }
    }
    
    // 走同步推数据到矩阵
    function push_sync($queue_id,&$data,$method) {
        $system_params = $this->_matrix_system_params();
        $data = array_merge($data, $system_params);
        
        foreach( $data as $k1=>$v1 ) {
            if ( !is_string($v1) ) {
                $data[$k1] = json_encode($v1);
            }
        }
        
        $data['method'] = $method;
        $data['sign'] = $this->system->loadModel('system/matrix')->get_matrix_sign($data);
        return $this->system->loadModel('utility/http_client')->post(MATRIX_DATA_EX_URI, $data);
    }
    
    // 走异步推数据到矩阵
    function push_async($queue_id,&$data,$method) {
        $system_params = $this->_matrix_system_params();
        $data = array_merge($data, $system_params);
        
        foreach( $data as $k1=>$v1 ) {
            if ( !is_string($v1) ) {
                $data[$k1] = json_encode($v1);
            }
        }
        $base_url = $this->system->base_url();
        $base_url = preg_replace('/plugins\/.*$/i','',$base_url);
        //$data['callback_url'] = $base_url.'api.php?act=ome:matrix_callback&return_data=json&queue_id='.$queue_id;
        $data['callback_url'] = $base_url.'api.php?act=ome:matrix_callback&return_data=json&api_version=2.0&queue_id='.$queue_id;
        $data['method'] = $method;
        $data['sign'] = $this->system->loadModel('system/matrix')->get_matrix_sign($data);
        return $this->system->loadModel('utility/http_client')->post(MATRIX_DATA_EX_ASYNC_URI, $data);
    }
    
    // 矩阵通讯系统参数
    function _matrix_system_params() {
        $certMdl =& $this->system->loadModel('service/certificate');
        
        return array(
            // 自身节点
            'from_node_id' => $certMdl->getNodeid(),
            'certi_id' => $certMdl->getCerti(),
            
            // OME节点
            'to_node_id' => $this->system->getConf('app.ome.omenodeid'),
            'app_id' => 'shopex_b2c',
            'to_node_type' => 'ecos.ome',

            'node_id' => $certMdl->getNodeid().'_'.$this->system->getConf('app.ome.omenodeid'),
            'node_type' => 'ecos.ome',
            
            'date' => date('Y-m-d H:i:s', NOW),
            'v' => '1',
            'format' => 'json',
            'to_api_v' => '2.2',
            'from_api_v' => '2.0',
        );
    }
}
