<?php

class api_refund extends shop_api_object {

    function dorefund($refund){
        if ( 0 >= +$refund['money'] ) {
            $this->api_response('fail','data fail',null,'退款金额必须大于零');
        }
        
        // 检查订单存在
        $orderMdl = &$this->system->loadModel('trading/order');
        if ( (!$order_id = $refund['order_id']) || (!$order = $orderMdl->instance($order_id)) ) {
            $this->api_response('fail','data fail',null,'订单号不存在');
        }
        if ( 'active' != $order['status']) {
            $this->api_response('fail','data fail',null,'订单非Active状态');
        }
        if ( 0 >= +$order['payed'] ) {
            $this->api_response('fail','data fail',null,'订单尚未付款');
        }
        
        // 检查会员
        if( (!$uname=$refund['member_id']) ||
            (!$member = $this->db->selectrow('SELECT member_id FROM sdb_members WHERE uname='.$this->db->quote($uname))) ) {
            $this->api_response('fail','data fail',null,'会员不存在');
        }
        if ( $member['member_id'] != $order['member_id'] ) {
            $this->api_response('fail','data fail',null,'会员订单不匹配');
        }
        
        // 检查支付方式
        if ( !$pay_type=$refund['payment'] ){
            $this->api_response('fail','data fail',null,'未指定支付方式');
        }
        $payment_cfg = $this->db->selectrow('SELECT id,custom_name FROM sdb_payment_cfg WHERE pay_type='.$this->db->quote($pay_type));
        if ( !$payment_cfg ) {
            $this->api_response('fail','data fail',null,'没有对应支付方式');
        }
        
        $paymentMdl = $this->system->loadModel('trading/payment');
        $refund_=array(
            'refund_id'=>$paymentMdl->gen_id(),
            'order_id'=>$order_id,
            'member_id'=>$order['member_id'],
            'account'=>$refund['account'],
            'bank'=>$refund['bank'],
            'pay_account'=>$refund['pay_account'],
            'currency'=>$refund['currency'],
            'cur_money'=>$refund['money']*$order['cur_rate'],
            'money'=>$refund['money'],
            'pay_type'=>$pay_type,
            'payment'=>$payment_cfg['id'],
            'paymethod'=>$payment_cfg['custom_name'],
            'ip'=>$data['ip'],
            't_ready'=>NOW,'t_sent'=>NOW,'t_received'=>NOW,
            
            'status'=>'sent',
            'memo'=>'ome同步退款单',
            'title'=>'title',
            'send_op_id'=>$refund['send_op_id'],
            'trade_no'=>$refund['order_id'],//交易流水单号
        );
        
        $payed_money = +$order['payed'];
        $refund_money = $this->db->select('SELECT SUM(money) money FROM sdb_refunds WHERE status="sent" AND order_id ='.$this->db->quote($order_id));
        $refund_money = $refund_money[0]['money'] + $refund['money'];
        if ( $refund_money > $payed_money ) {
            $this->api_response('fail','data fail',null,'退款金额大于订单支付金额');
        } elseif ( $payed_money == $refund_money ) {
            $pay_status = PAYMENT_REFUNDS_ALL;
        } else {
            $pay_status = PAYMENT_REFUNDS_PART;
        }
        
        if ( 'deposit' == $pay_type ) {
            $advanceMdl = $this->system->loadModel('member/advance');
            $advance = +($advanceMdl->get($member['member_id']) + $refund['money']);
            
            $this->db->exec('UPDATE sdb_members SET advance=$advance WHERE member_id='.intval($member['member_id']));
            $message = '预存款退款：#O{'.$order_id.'}#';
            
            $advanceMdl->log($member['member_id'],$refund['money'],$message,
                $refund_['refund_id'],$refund['order_id'],$refund_['paymethod'],$refund_['paymethod'],$advance);
        }

        $this->db->insert('sdb_refunds',$refund_);
        $now = NOW;
        $this->db->exec('UPDATE sdb_orders set pay_status ="$pay_status",last_change_time=$now WHERE order_id='.$this->db->quote($order_id));

        $orderMdl->fireEvent('refund',array('order_id'=>$order_id));
        
        $refund = $this->system->loadModel('system/matrix')->format_matrix_refund($refund_['refund_id']);
        
        $this->api_response('true',$refund,'退款单新建成功');
    }
}
