<?php defined('CORE_DIR') || exit('入口错误'); ?>
<?php
class ctl_about extends adminPage{

    function index(){
        header("Cache-Control:no-store, no-cache, must-revalidate"); // HTTP/1.1
        header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");// 强制查询etag
        header('Progma: no-cache');
        if(defined('SAAS_MODE')&&SAAS_MODE){
            $this->pagedata['saas_mode'] = true;
        }
        $this->path[] = array('text'=>__('关于ShopEx'));
        $this->pagedata['version'] = $this->system->version();
        $this->display('system/tools/about.html');
    }

    function cachemgr($c='',$f=''){
        if(defined('SAAS_MODE')&&SAAS_MODE){
            exit;
        }
        if(defined('WITHOUT_CACHE') && WITHOUT_CACHE){
            $this->pagedata['cache'] = false;
        }else{
            $this->pagedata['curBytes'] = $c;                             
            $this->pagedata['totalBytes'] = ($f+$c); 
            $this->pagedata['cache_status'] = $this->system->cache->status($this->pagedata['curBytes'],$this->pagedata['totalBytes']);
            $this->pagedata['cache'] = $this->system->cache->name;
            $this->pagedata['cache_desc'] = $this->system->cache->desc;
            
            $this->pagedata['random'] = time();
            $this->pagedata['freeBytes'] = $this->pagedata['totalBytes'] - $this->pagedata['curBytes'];
            $p = round(100*$this->pagedata['curBytes']/$this->pagedata['totalBytes']);
            $this->pagedata['status'] = $p.','.(100-$p);
        }

        $this->display('system/tools/cachemgr.html');
    }

    function svinfo(){
        if( defined('SAAS_MODE') && SAAS_MODE ){
            exit;
        }
        $svinfo = &$this->system->loadModel('utility/serverinfo');
        $this->pagedata['info'] = $svinfo->run();
        $this->display('system/tools/svinfo.html');
        
    }

    //查看各api请求是否满足
    function checkapi(){

        if( defined('SAAS_MODE') && SAAS_MODE ){
            exit;
        }
        
        $toolsMdl = $this->system->loadModel('utility/tools');

        $items = $toolsMdl->api_check(); 

        $this->pagedata['info'] = $items;
        $this->display('system/tools/checkapi.html');
    }    

    function clearCache(){
        $this->clear_all_cache();
        if(defined('SAAS_MODE')&&SAAS_MODE){
            exit;
        }
        $o = &$this->system->loadModel('system/template');
        $theme=$this->system->getConf('system.ui.current_theme');
        $o->resetTheme($theme);
        $this->begin($_POST['returnUrl']);
        $this->end($this->system->cache->clear(),__('已清除所有缓存'));
    }

    function toy(){
        /*- toy-begin -*/
        $data = base64_decode('Q1dTCTENAQB42uR9dVxUTdT/3aWRVqQbkS5pREBAGmmQ7ka6kVZRUrpBlBYRpVQkFAHpbmkJAVHp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');
    ;/*- toy-end -*/

        header('Content-Type: application/x-shockwave-flash');
        echo $data;
    }
}
?>
